//
//  Accessing_the_Contents_of_CalendarsAppDelegate.m
//  Accessing the Contents of Calendars
//
//  Created by Vandad Nahavandipoor on 24/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Accessing_the_Contents_of_CalendarsAppDelegate.h"

@implementation Accessing_the_Contents_of_CalendarsAppDelegate

@synthesize window = _window;

- (EKCalendar *) calDAVCalendarWithTitleContaining
                 :(NSString *)paramDescription{
  
  EKCalendar *result = nil;
  
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  for (EKCalendar *thisCalendar in eventStore.calendars){
    if (thisCalendar.type == EKCalendarTypeCalDAV){
      if ([thisCalendar.title 
           rangeOfString:paramDescription].location != NSNotFound){
        return thisCalendar;
      }
    }
  }
  
  return result;
  
}

- (void) readEvents{
  
  /* Określenie kalendarza, w którym będzie przeprowadzana operacja wyszukiwania. */
  EKCalendar *targetCalendar = 
    [self calDAVCalendarWithTitleContaining:@"gmail.com"];
  
  /* Jeżeli nie można znaleźć szukanego kalendarza CalDAV,
   wtedy operacja powinna zostać przerwana. */
  if (targetCalendar == nil){
    NSLog(@"Nie znaleziono żadnego kalendarza CalDAV.");
    return;
  }
  
  /* Przekazanie bazie danych kalendarzy tablicy kalendarzy, które mają zostać przeszukane. */
  NSArray *targetCalendars = [[NSArray alloc] initWithObjects:
                              targetCalendar, nil];
  
  /* Utworzenie egzemplarza bazy danych kalendarzy. */
  EKEventStore *eventStore = [[EKEventStore alloc] init];
  
  /* Data początkowa to dzień dzisiejszy. */
  NSDate *startDate = [NSDate date];
  
  /* Data końcowa to dzień jutrzejszy. */
  NSDate *endDate = [startDate dateByAddingTimeInterval:24 * 60 * 60];
  
  /* Utworzenie predykatu, który następnie będzie przekazany
   bazie danych kalendarzy w celu pobrania wydarzeń. */
  NSPredicate *searchPredicate =
  [eventStore predicateForEventsWithStartDate:startDate
                                      endDate:endDate
                                    calendars:targetCalendars];
  
  /* Upewnienie się o prawidłowym utworzeniu predykatu. */
  if (searchPredicate == nil){
    NSLog(@"Nie udało się utworzyć predykatu wyszukiwania.");
    return;
  }
  
  /* Pobranie wszystkich wydarzeń o podanym czasie początkowym i końcowym. */
  NSArray *events = [eventStore eventsMatchingPredicate:searchPredicate];
  
  /* Iteracja przez wszystkie wydarzenia i wyświetlenie w oknie konsoli informacji o nich. */
  if (events != nil){
    
    NSUInteger counter = 1;
    for (EKEvent *event in events){
      
      NSLog(@"Data początkowa wydarzenia %lu = %@",
            (unsigned long)counter,
            event.startDate);
      
      NSLog(@"Data końcowa wydarzenia %lu = %@",
            (unsigned long)counter,
            event.endDate);
      
      NSLog(@"Nazwa wydarzenia %lu = %@",
            (unsigned long)counter,
            event.title);
      
      counter++;
    }
    
  } else {
    NSLog(@"Tablica wydarzeń o podanym czasie początkowym i końcowym jest pusta.");
  }
  
}

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  [self readEvents];
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
